public class Duration {
	private long hours;
	private int minutes, seconds;
	private final static long MAX_HOURS = 2562047788015214L;

	// (MAX_HOURS+1)*3600 bleibt gerade unter 2^63-1. Die Grenze für hours sorgt dafür, dass toSeconds() korrekt arbeitet.  
	// Maximale von einem Duration-Objekt darstellbare Zeitdauer: ungefähr 3E+11 Jahre

	public Duration(long h, int min, int sec) {
		setDuration(h, min, sec);
	}

	public Duration(long secTotal) {
		setDuration(secTotal);
	}
	
	public Duration() {}

	public boolean setDuration(long h, int min, int sec) {
		if ((h >= 0 && h <= MAX_HOURS) && (min >= 0 && min <= 59) &&	(sec >= 0 && sec <= 59)) {
			hours = h;
			minutes = min;
			seconds = sec;
			return true;
		} else
			return false;
	}

	public boolean setDuration(long secTotal) {
		if (secTotal >= 0) {
			hours = secTotal/3600;
			minutes = (int) (secTotal-hours*3600)/60;
			seconds = (int) (secTotal-hours*3600-minutes*60);
			return true;
		} else
			return false;
	}

	public long getHours() {
		return hours;
	}

	public int getMinutes() {
		return minutes;
	}

	public int getSeconds() {
		return seconds;
	}

	public boolean setHours(long h) {
		if (h >= 0 && h <= MAX_HOURS) {
			hours = h;
			return true;
		} else
			return false;
	}

	public boolean setMinutes(int min) {
		if (min >= 0 && min <= 59) {
			minutes = min;
			return true;
		} else
			return false;
	}

	public boolean setSeconds(int sec) {
		if (sec >= 0 && sec <= 59) {
			seconds = sec;
			return true;
		} else
			return false;
	}
	
	public long toSeconds() {
		return hours * 3600 + minutes * 60 + seconds;
	}

	public String toString(){
		return String.format("%16d:%02d:%02d %s", hours, minutes, seconds, "h:m:s").trim();
	}
}
